<?php
/**
 * OTIMIZAÇÃO DE PERFORMANCE E BLINDAGEM DE MEMÓRIA
 */
ini_set('memory_limit', '512M'); 
ini_set('display_errors', 0);    
error_reporting(E_ALL);

include "header.php";

$userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36';

function getApiData($url, $userAgent) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_ENCODING, ""); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 12);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($httpCode !== 200 || !$response) return [];
    $decoded = json_decode($response, true);
    unset($response); 
    return is_array($decoded) ? $decoded : [];
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$selected_season = isset($_GET['season']) ? (int)$_GET['season'] : null;
$tmdb_api_key = "95497bb6942dfa426d495f9350f011b9"; 

if (!$id) die("ID Inválido.");

$get_dns = $get_dns ?? '';
$username = $username ?? '';
$password = $password ?? '';

$api_url = "{$get_dns}/player_api.php?username={$username}&password={$password}&action=get_series_info&series_id={$id}";
$series_data = getApiData($api_url, $userAgent);

if (!isset($series_data['info'])) die("Série não encontrada.");

$series_info = $series_data['info'];
$title = $series_info['name'] ?? 'Sin título';
$description = $series_info['plot'] ?? 'Sem descrição disponível.';
$backdrop = $series_info['backdrop_path'][0] ?? "https://i.postimg.cc/YCDngMfZ/Design-sem-nome-2.png";
$poster = $series_info['cover'] ?? "https://i.imgur.com/Mn7aXQD.jpg";
$rating = $series_info['rating'] ?? 'N/A';

$youtube_trailer = '';
$cast_list = '';

$tmdb_search = "https://api.themoviedb.org/3/search/tv?api_key={$tmdb_api_key}&query=" . urlencode($title);
$tmdb_res = getApiData($tmdb_search, $userAgent);

if (!empty($tmdb_res['results'])) {
    $tmdb_id = $tmdb_res['results'][0]['id'];
    $tr_url = "https://api.themoviedb.org/3/tv/{$tmdb_id}/videos?api_key={$tmdb_api_key}";
    $tr_data = getApiData($tr_url, $userAgent);
    foreach ($tr_data['results'] ?? [] as $video) {
        if ($video['site'] === 'YouTube' && $video['type'] === 'Trailer') {
            $youtube_trailer = $video['key']; break;
        }
    }
    unset($tr_data);

    $cr_url = "https://api.themoviedb.org/3/tv/{$tmdb_id}/credits?api_key={$tmdb_api_key}";
    $cr_data = getApiData($cr_url, $userAgent);
    foreach (array_slice($cr_data['cast'] ?? [], 0, 5) as $actor) {
        $img = $actor['profile_path'] ? "https://image.tmdb.org/t/p/w200" . $actor['profile_path'] : "https://i.postimg.cc/YCDngMfZ/Design-sem-nome-2.png";
        $cast_list .= "<div class='actor'><img src='{$img}' class='actor-img'><div class='actor-name'>{$actor['name']}</div></div>";
    }
    unset($cr_data);
}

$seasons_list = array_keys($series_data['episodes'] ?? []);
if ($selected_season === null && !empty($seasons_list)) {
    $selected_season = $seasons_list[0];
}

$episodes = $series_data['episodes'][$selected_season] ?? [];
unset($series_data); 
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
    <title><?= htmlspecialchars($title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;600;800&display=swap');
        
        body { background: #060608; color: #ffffff; font-family: 'Montserrat', sans-serif; overflow-x: hidden; }

        .hero { 
            position: relative; min-height: 70vh; display: flex; align-items: center; 
            background: url('<?= $backdrop ?>') center center/cover no-repeat fixed;
            padding: 80px 0 40px 0;
        }
        .hero::before { 
            content: ''; position: absolute; inset: 0; 
            background: linear-gradient(to top, #060608 5%, rgba(6,6,8,0.5) 50%, rgba(6,6,8,0.8) 100%); 
        }

        .hero-content { position: relative; z-index: 10; }
        
        .poster-wrapper img { 
            width: 220px; border-radius: 15px; box-shadow: 0 15px 40px rgba(0,0,0,0.8);
            border: 1px solid rgba(255,255,255,0.1); margin-bottom: 25px;
        }

        .series-info-card {
            background: rgba(255, 255, 255, 0.04); backdrop-filter: blur(20px);
            padding: 30px; border-radius: 25px; border: 1px solid rgba(255,255,255,0.1);
        }

        .rating-badge {
            background: #ffc107; color: #000; padding: 4px 12px; border-radius: 6px;
            font-weight: 800; font-size: 0.9rem; margin-bottom: 15px; display: inline-block;
        }

        .btn-stream { 
            background: #e50914; color: #fff; border: none; padding: 12px 25px; 
            border-radius: 10px; font-weight: 700; transition: 0.3s;
            text-transform: uppercase; font-size: 0.9rem; text-decoration: none;
            display: inline-flex; align-items: center; gap: 8px;
        }
        .btn-stream:hover { transform: translateY(-3px); background: #f40a15; color: #fff; box-shadow: 0 8px 20px rgba(229, 9, 20, 0.4); }

        .season-nav { 
            display: flex; gap: 10px; overflow-x: auto; padding: 15px 5px; 
            scrollbar-width: none; border-bottom: 1px solid rgba(255,255,255,0.05);
        }
        .season-nav::-webkit-scrollbar { display: none; }
        .nav-link-season { 
            white-space: nowrap; color: rgba(255,255,255,0.5); padding: 8px 18px; 
            border-radius: 8px; text-decoration: none; font-weight: 600; transition: 0.2s;
            background: rgba(255,255,255,0.03);
        }
        .nav-link-season.active { background: #e50914; color: #fff; }

        .episode-card { 
            background: rgba(255,255,255,0.03); border-radius: 12px; overflow: hidden; 
            border: 1px solid rgba(255,255,255,0.05); transition: 0.3s; cursor: pointer;
        }
        .episode-card:hover { border-color: #e50914; transform: translateY(-5px); background: rgba(255,255,255,0.06); }
        
        .ep-img-wrapper { position: relative; width: 100%; height: 140px; background: #1a1a1a; display: flex; align-items: center; justify-content: center; }
        .ep-img-wrapper img { width: 100%; height: 100%; object-fit: cover; z-index: 1; }
        .ep-img-wrapper i.fa-video { position: absolute; font-size: 2rem; color: rgba(255,255,255,0.1); z-index: 0; }
        
        .ep-play-overlay { 
            position: absolute; inset: 0; background: rgba(0,0,0,0.4); 
            display: flex; align-items: center; justify-content: center; opacity: 0; transition: 0.3s; z-index: 2;
        }
        .episode-card:hover .ep-play-overlay { opacity: 1; }
        .ep-play-overlay i { font-size: 2.5rem; color: #fff; filter: drop-shadow(0 0 10px rgba(229, 9, 20, 0.8)); }

        .actor-img { 
            width: 65px; height: 65px; border-radius: 50%; object-fit: cover; 
            border: 2px solid rgba(255,255,255,0.1);
        }

        .modal-custom {
            display: none; position: fixed; inset: 0; z-index: 9999; 
            background: rgba(0,0,0,0.92); backdrop-filter: blur(10px); align-items: center; justify-content: center;
        }
        .modal-content-ui {
            background: #0f0f13; width: 95%; max-width: 1100px; height: 85vh;
            border-radius: 20px; overflow-y: auto; padding: 25px; border: 1px solid rgba(255,255,255,0.1);
        }

        @media (max-width: 991px) {
            .hero { padding-top: 40px; text-align: center; background-attachment: scroll; }
            .series-info-card { padding: 20px; }
            .cast-container { justify-content: center; }
            .display-4 { font-size: 2rem; }
            .hero-content .row { flex-direction: column; }
            .poster-wrapper img { width: 180px; }
        }
    </style>
</head>
<body>

<div class="hero">
    <div class="container hero-content">
        <div class="row align-items-center">
            <div class="col-lg-3 poster-wrapper">
                <img src="<?= $poster ?>" class="img-fluid" alt="Poster">
            </div>
            <div class="col-lg-9">
                <div class="series-info-card">
                    <span class="rating-badge"><i class="fas fa-star me-1"></i> <?= $rating ?></span>
                    <h1 class="display-4 fw-bolder"><?= htmlspecialchars($title) ?></h1>
                    <p class="lead opacity-75" style="font-size: 1rem;"><?= htmlspecialchars($description) ?></p>
                    
                    <div class="cast-container d-flex gap-3 mt-4 overflow-hidden flex-wrap">
                        <?= $cast_list ?>
                    </div>

                    <div class="d-flex gap-2 mt-4 justify-content-center justify-content-lg-start flex-wrap">
                        <button onclick="toggleModal('episodesModal', true)" class="btn-stream">
                            <i class="fas fa-play-circle"></i> Ver Episódios
                        </button>
                        <?php if($youtube_trailer): ?>
                            <button onclick="toggleModal('trailerModal', true)" class="btn-stream bg-dark border border-secondary">
                                <i class="fab fa-youtube text-danger"></i> Trailer
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container mt-4">
    <div class="season-nav">
        <?php foreach ($seasons_list as $num): ?>
            <a href="?id=<?= $id ?>&season=<?= $num ?>" class="nav-link-season <?= ($num == $selected_season) ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt me-1"></i> Temporada <?= $num ?>
            </a>
        <?php endforeach; ?>
    </div>
</div>

<div id="episodesModal" class="modal-custom">
    <div class="modal-content-ui">
        <div class="d-flex justify-content-between align-items-center mb-4 border-bottom pb-3 border-secondary">
            <h4 class="fw-bold m-0"><i class="fas fa-layer-group me-2"></i>Temporada <?= $selected_season ?></h4>
            <button onclick="toggleModal('episodesModal', false)" class="btn btn-link text-white text-decoration-none fs-3">&times;</button>
        </div>
        <div class="row g-3">
            <?php foreach ($episodes as $ep): ?>
                <?php 
                    $ep_img = $ep['info']['movie_image'] ?? 'https://i.imgur.com/Mn7aXQD.jpg';
                    $player_url = "video_player?id={$ep['id']}&slug=series&ext=".($ep['container_extension'] ?? 'mp4')."&series_id={$id}";
                ?>
                <div class="col-6 col-md-4 col-lg-3">
                    <div class="episode-card h-100" onclick="location.href='<?= $player_url ?>'">
                        <div class="ep-img-wrapper">
                            <i class="fas fa-video"></i>
                            <img src="<?= $ep_img ?>" alt="EP" loading="lazy">
                            <div class="ep-play-overlay">
                                <i class="fas fa-play-circle"></i>
                            </div>
                        </div>
                        <div class="p-2">
                            <small class="text-danger fw-bold" style="font-size: 0.7rem;">EP <?= htmlspecialchars($ep['episode_num'] ?? '') ?></small>
                            <p class="m-0 fw-semibold text-truncate" style="font-size: 0.8rem;"><?= htmlspecialchars($ep['title']) ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<div id="trailerModal" class="modal-custom">
    <div style="width: 95%; max-width: 900px; background: #000; border-radius: 15px; overflow: hidden;">
        <div class="ratio ratio-16x9">
            <iframe id="trailerIframe" src="" allow="autoplay; encrypted-media" allowfullscreen></iframe>
        </div>
        <button onclick="toggleModal('trailerModal', false)" class="btn btn-dark w-100 py-3 rounded-0 fw-bold">
            <i class="fas fa-times me-2"></i>FECHAR
        </button>
    </div>
</div>

<script>
    function toggleModal(id, show) {
        const modal = document.getElementById(id);
        modal.style.display = show ? 'flex' : 'none';
        document.body.style.overflow = show ? 'hidden' : 'auto';
        
        if(id === 'trailerModal') {
            const iframe = document.getElementById('trailerIframe');
            iframe.src = show ? "https://www.youtube.com/embed/<?= $youtube_trailer ?>?autoplay=1" : "";
        }
    }

    window.onclick = function(e) {
        if (e.target.className === 'modal-custom') {
            toggleModal(e.target.id, false);
        }
    }
</script>

</body>
</html>